/*------------------------------------------------------------------------------*
 * File Name: ImpWizSource.c													*
 * Creation: 																	*
 * Purpose: Origin C file containing Application Utilities						*
 * Copyright (c) OriginLab Corp.	2002-2007									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * SY 01/04/2005 QA70-6555 v8.0181 USING_MULTI_OPEN_FDLOG						*
 * EJP 01-04-2005 v8.0181 QA70-6555 NEW_IMPORT_MODES							*
 * EJP 2005-08-15 v8.0288 QA70-7996 IMPWIZ_SUPPORT_XFUNC						*
 * EJP 2005-11-21 v8.0340 FOR_CONTROL_UPGRADE_DATA								*
 * EJP 2006-03-27 v8.0381 AUTO_SELECT_FILTER_REGADLESS_OF_LOCATION				*
 * EJP 2006-06-29 v8.0434 ONLY_PUT_XFUNC_NAME_INTO_FILTER						*
 * EJP 2006-07-19 v8.0447 SUPPORT_TARGET_PG_IN_XFUNC_IMP_FILTER					*
 * AW  10/30/06 v8.0503 TEMP_REMOVE_XF_FROM_IMPORT_WIZARD						*
 * Hong 02/26/07 ADD_WORKSHEET_TO_FIRST_VARIABLE								*
 * Hong 02/27/07 QA80-9410 MORE_RENAME_WORKSHEET_WITH_VARIABLE					*
 * Sim 03-06-2007 MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF							*
 * Hong 04/10/07 v8.697b REMOVE_AUTO_IMPORT_MODE								*
 * Sim 05-30-2007 FIX_IMPORT_MODE												*
 * Sim 06-04-2007 SOME_PAGES_TO_BE_EXCLUDED_FROM_MANAGER						*
 * Sim 06-23-2007 FIX_CHANGE_TO_BINARY_SETTING									*
 * Hong 11/01/07 v8.0738b DISALBE_RENAME_FOR_CLIPBOARD							*
 * Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME		*
 *	Hong 03/23/09 FIX_FILTER_NOT_RELOADED_EVEN_COMBO_HAVE_CHANGED_WHEN_CLICK_DISPLAY_COMPATIBLE_BTN
 *	Folger 04/30/09 SHARE_IMPORT_WIZARD_FILTER_LIST_CONSTRUCTION_WITH_BATCH_PROCESS_TOOL
 *	Folger 10/19/2010 ORG-1279 DIALOG_DISPLAY_NOT_GOOD_IN_CHINESE				*
 *------------------------------------------------------------------------------*/

#include <Origin.h>
#include "IWfirst.h"

///Danice 12/25/03 v7.5788 NOTUSE_SHOW
DWORD ImpWizSourcePage::OnShowStatus(DWORD InternalStatus)
{
	return PSS_Show ;
}
///END NOTUSE_SHOW

//Events handles
bool ImpWizSourcePage::OnInitSource()		///Danice 12/12/03 v7.5780 CHANGE_SOME_FUNCTION_NAME
{
	///Danice PAGE_INIT_ONCE
	if(!ImpWizardPage::Init())
		return FALSE;
	///END PAGE_INIT_ONCE

	///Danice 12/14/03 v7.5781 GET_CONTROL_IN_START : initialization control
	m_btnBrowse 			= GetItem(IDC_SOURCE_BROWSE);
	m_cbFilters 			= GetItem(IDC_SOURCE_FILTER);
	m_cbWksTemplate 		= GetItem(IDC_TARGET_WKS_TEMPLATE);
	m_chkCompatibleFilters 	= GetItem(IDC_DISPLAY_ONLY_COMPATIBLE_CHK);
	/// EJP 11-11-2004 v8.0163 QA70-6554 EXTRACT_VARS_FROM_FILENAME
	///m_chkFileNameToWksLabel = GetItem(IDC_IW_FILENAME_TO_WKSLABEL);
	/// end EXTRACT_VARS_FROM_FILENAME
	m_chkMat 				= GetItem(IDC_TARGET_MATRIX);
	/// EJP 11-11-2004 v8.0163 QA70-6554 EXTRACT_VARS_FROM_FILENAME
	///m_chkRenameWks 			= GetItem(IDC_IW_SOURCE_RENAMEWKS);
	/// end EXTRACT_VARS_FROM_FILENAME
	//m_chkWks 				= GetItem(IDC_TARGET_WKS);	///Danice 12/12/03 BUTTON_DEFINED_NOT_USE
	m_ebDescrip 			= GetItem(IDC_FILTER_DESCRIP);
	m_editFileName 			= GetItem(IDC_SOURCE_FILENAME);
	m_radMatrix 			= GetItem(IDC_TARGET_MATRIX);
	m_radWndNone 			= GetItem(IDC_TARGET_WND_NONE);
	///END GET_CONTROL_IN_START

	/// EJP 2005-08-15 v8.0288 QA70-7996 IMPWIZ_SUPPORT_XFUNC
	m_radWks = GetItem(IDC_TARGET_WKS);
	/// AW  10/30/06 v8.0503 TEMP_REMOVE_XF_FROM_IMPORT_WIZARD
	/*
	m_cbXFuncs = GetItem(IDC_XFUNCS);
//	{
		int nIDXF = IDXF_USGCTXT_IMPORTWIZ;
		vector<string> vsNames;
		int nNumFiles = okutil_find_files_from_map(&vsNames, NULL, SUPPORTFILE_XF, 0, &nIDXF, 1);
		for( int ii = 0; ii < nNumFiles; ii++ )
			m_cbXFuncs.AddString(vsNames[ii]);
//	}
	*/
	/// END TEMP_REMOVE_XF_FROM_IMPORT_WIZARD
	/// end IMPWIZ_SUPPORT_XFUNC

	/// EJP 01-04-2005 v8.0181 QA70-6555 NEW_IMPORT_MODES
    m_cbImportMode = GetItem(IDC_RANGE_MODE);
    /// Hong 04/10/07 v8.697b REMOVE_AUTO_IMPORT_MODE
    //SetComboBoxItems(m_cbImportMode, _L("Auto|Replace Exisiting Data|Start New Books|Start New Sheets|Start New Columns|Start New Rows"), '|');
    SetComboBoxItems(m_cbImportMode, _L("Replace Existing Data|Start New Books|Start New Sheets|Start New Columns|Start New Rows"), '|');
    /// end REMOVE_AUTO_IMPORT_MODE
    /// end NEW_IMPORT_MODES

    /// EJP 11-11-2004 v8.0163 QA70-6554 EXTRACT_VARS_FROM_FILENAME
	///	/// EJP 07-07-2004 v8.0903 QA70-6555 SUPPORT_WORKBOOK_IMPWIZ
	///	m_chkRenWkbk = GetItem(IDC_SRC_REN_WKBK);
	///	m_chkIncludePath = GetItem(IDC_SRC_REMOVE_FNAME_PATH);
	///	m_chkFNameToWkbkComments = GetItem(IDC_IW_FILENAME_TO_WKSLABEL);
	///	m_chkFNameToColComments = GetItem(IDC_SRC_APPEND_TO_COL_COMMENTS);
	///	/// end SUPPORT_WORKBOOK_IMPWIZ
	/// end EXTRACT_VARS_FROM_FILENAME
	
	//LPCSTR lpcszDataFile; 	///---Sim 01-04-2006 INIT_WITH_MULTI_FILE no need
	///Danice 12/12/03 v7.5780 NOT_NEED_CALL_CONTROL
	//Control pgSource = ImportWizDlg.GetItem(IDD_IW_SOURCE);
	
	//Edit editFileName = ImportWizDlg.GetItem(IDC_SOURCE_FILENAME, IDD_IW_SOURCE);	///Danice 12/12/03 v7.5780 GET_IN_INITIALIZATION
	if( IS_DATAFROM_CLIPBOARD )
	{
		//pgSource.CheckRadioButton(IDC_SOURCE_FILE, IDC_SOURCE_CLIPBOARD, IDC_SOURCE_CLIPBOARD);
		CheckRadioButton(IDC_SOURCE_FILE, IDC_SOURCE_CLIPBOARD, IDC_SOURCE_CLIPBOARD);
		m_editFileName.Text = "";
		//lpcszDataFile = NULL;	///---Sim 01-04-2006 INIT_WITH_MULTI_FILE no need
	}
	else
	{
		//pgSource.CheckRadioButton(IDC_SOURCE_FILE, IDC_SOURCE_CLIPBOARD, IDC_SOURCE_FILE);
		CheckRadioButton(IDC_SOURCE_FILE, IDC_SOURCE_CLIPBOARD, IDC_SOURCE_FILE);
		///END NOT_NEED_CALL_CONTROL
		///---Sim 01-04-2006 INIT_WITH_MULTI_FILE
		//m_editFileName.Text = s_strDataFile;
		SetComboBoxItems(m_editFileName, m_pSheet->GetDataFiles());
		m_editFileName.SetCurSel(0); // select first file
		//lpcszDataFile = s_strDataFile;	// no need
		///---Sim 01-04-2006 INIT_WITH_MULTI_FILE
	}

	m_bFileNameChanged = false; /// SY 01/06/2005 v8.0183 QA70-6555 USING_MULTI_OPEN_FDLOG

	///Danice 12/12/03 v7.5780 GET_IN_INITIALIZATION
	//ComboBox cbWksTemplate = ImportWizDlg.GetItem(IDC_TARGET_WKS_TEMPLATE, IDD_IW_SOURCE);
	
	m_pSheet->InitComboBoxWithTemplateNames(m_cbWksTemplate, EXIST_WKS);

	///ComboBox cbMatrixTemplate = ImportWizDlg.GetItem(IDC_TARGET_MATRIX_TEMPLATE, IDD_IW_SOURCE);
	///InitComboBoxWithTemplateNames(cbMatrixTemplate, EXIST_MATRIX);

	Source_UpdateFilter(FALSE);
	Source_EnableDataSourceCtrls();
	Source_EnableTargetWindowCtrls();
	Source_UpdateButtons();

	//Button chkCompatibleFilters = ImportWizDlg.GetItem(IDC_DISPLAY_ONLY_COMPATIBLE_CHK, IDD_IW_SOURCE);
	///END GET_IN_INITIALIZATION
	
	m_chkCompatibleFilters.Check = 1;

	Source_UpdateFilterComboBox();
	Source_LoadCurSelFilter();

	///------ Folger 10/19/2010 ORG-1279 DIALOG_DISPLAY_NOT_GOOD_IN_CHINESE
	CheckResizeFilterControl();
	///------ End DIALOG_DISPLAY_NOT_GOOD_IN_CHINESE

	return true;
}

void ImpWizSourcePage::Source_EnableDataSourceCtrls()
{
	///Danice 12/12/03 v7.5780 NOT_NEED_CALL_CONTROL
	//Control pgSource = ImportWizDlg.GetItem(IDD_IW_SOURCE);
	
	//Button radClipboard = ImportWizDlg.GetItem(IDC_SOURCE_CLIPBOARD, IDD_IW_SOURCE);	///Danice 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL
	Button radClipboard = GetItem(IDC_SOURCE_CLIPBOARD);

	/// EJP 2005-08-15 v8.0288 QA70-7996 IMPWIZ_SUPPORT_XFUNC
	///	//int iDataType = pgSource.GetCheckedRadioButton(IDC_DATATYPE_ASCII, IDC_DATATYPE_USERDEF);
	///	int iDataType = GetCheckedRadioButton(IDC_DATATYPE_ASCII, IDC_DATATYPE_USERDEF);
	/// AW  10/30/06 v8.0503 TEMP_REMOVE_XF_FROM_IMPORT_WIZARD
	//int iDataType = GetCheckedRadioButton(IDC_DATATYPE_ASCII, IDC_DATATYPE_XFUNC);
	int iDataType = GetCheckedRadioButton(IDC_DATATYPE_ASCII, IDC_DATATYPE_USERDEF);
	/// END TEMP_REMOVE_XF_FROM_IMPORT_WIZARD
	/// end IMPWIZ_SUPPORT_XFUNC

	if( IDC_DATATYPE_BINARY == iDataType )
	{
		//pgSource.CheckRadioButton(IDC_SOURCE_FILE, IDC_SOURCE_CLIPBOARD, IDC_SOURCE_FILE);
		CheckRadioButton(IDC_SOURCE_FILE, IDC_SOURCE_CLIPBOARD, IDC_SOURCE_FILE);
		SET_DATAFROM_FILE;
		radClipboard.Enable = false;
	}
	else
		radClipboard.Enable = true;

	//int iDataSource = pgSource.GetCheckedRadioButton(IDC_SOURCE_FILE, IDC_SOURCE_CLIPBOARD);
	int iDataSource = GetCheckedRadioButton(IDC_SOURCE_FILE, IDC_SOURCE_CLIPBOARD);
	Source_EnableFileCtrls(IDC_SOURCE_FILE == iDataSource);
	///END NOT_NEED_CALL_CONTROL
}	

void ImpWizSourcePage::Source_EnableFileCtrls(BOOL bEnable) //=true)
{
	///Danice 12/12/03 v7.5780 GET_IN_INITIALIZATION
	//Edit ebFileName = ImportWizDlg.GetItem(IDC_SOURCE_FILENAME, IDD_IW_SOURCE);
	m_editFileName.Enable = bEnable;

	//Button btnBrowse = ImportWizDlg.GetItem(IDC_SOURCE_BROWSE, IDD_IW_SOURCE);
	m_btnBrowse.Enable = bEnable;

	/// EJP 11-11-2004 v8.0163 QA70-6554 EXTRACT_VARS_FROM_FILENAME
	/*
	//Button chkRenameWks = ImportWizDlg.GetItem(IDC_IW_SOURCE_RENAMEWKS, IDD_IW_SOURCE);
	m_chkRenameWks.Enable = bEnable;
	
	//Button chkFileNameToWksLabel = ImportWizDlg.GetItem(IDC_IW_FILENAME_TO_WKSLABEL, IDD_IW_SOURCE);
	m_chkFileNameToWksLabel.Enable = bEnable;
	///END GET_IN_INITIALIZATION

	/// EJP 07-07-2004 v8.0903 QA70-6555 SUPPORT_WORKBOOK_IMPWIZ
	m_chkRenWkbk.Enable = bEnable;
	m_chkFNameToWkbkComments.Enable = bEnable;
	m_chkFNameToColComments.Enable = bEnable;
	m_chkIncludePath.Enable = bEnable;
	/// end SUPPORT_WORKBOOK_IMPWIZ
	*/
	/// end EXTRACT_VARS_FROM_FILENAME
}

void ImpWizSourcePage::Source_EnableTargetWindowCtrls()
{
	///Danice 12/12/03 v7.5780 NOT_NEED_CALL_CONTROL
	//Control pgSource = ImportWizDlg.GetItem(IDD_IW_SOURCE);

	/// EJP 2005-08-15 v8.0288 QA70-7996 IMPWIZ_SUPPORT_XFUNC
	///	//int iDataType = pgSource.GetCheckedRadioButton(IDC_DATATYPE_ASCII, IDC_DATATYPE_USERDEF);
	///	int iDataType = GetCheckedRadioButton(IDC_DATATYPE_ASCII, IDC_DATATYPE_USERDEF);
	///
	///	///Danice 12/12/03 v7.5780 GET_IN_INITIALIZATION
	///	//Button radMatrix = ImportWizDlg.GetItem(IDC_TARGET_MATRIX, IDD_IW_SOURCE);
	///	m_radMatrix.Enable = (IDC_DATATYPE_USERDEF == iDataType);
	///	
	///	//Button radWndNone = ImportWizDlg.GetItem(IDC_TARGET_WND_NONE, IDD_IW_SOURCE);
	///	m_radWndNone.Enable = (IDC_DATATYPE_USERDEF == iDataType);
	/// AW  10/30/06 v8.0503 TEMP_REMOVE_XF_FROM_IMPORT_WIZARD
	//int iDataType = GetCheckedRadioButton(IDC_DATATYPE_ASCII, IDC_DATATYPE_XFUNC);
	int iDataType = GetCheckedRadioButton(IDC_DATATYPE_ASCII, IDC_DATATYPE_USERDEF);
	/// END TEMP_REMOVE_XF_FROM_IMPORT_WIZARD
	/// EJP 2006-07-19 v8.0447 SUPPORT_TARGET_PG_IN_XFUNC_IMP_FILTER
	///BOOL bEnable = (IDC_DATATYPE_USERDEF == iDataType);
	/// AW  10/30/06 v8.0503 TEMP_REMOVE_XF_FROM_IMPORT_WIZARD
	//BOOL bEnable = (IDC_DATATYPE_USERDEF == iDataType || IDC_DATATYPE_XFUNC == iDataType);
	BOOL bEnable = (IDC_DATATYPE_USERDEF == iDataType);
	/// END TEMP_REMOVE_XF_FROM_IMPORT_WIZARD
	/// end SUPPORT_TARGET_PG_IN_XFUNC_IMP_FILTER
	m_radWks.Enable = bEnable;
	m_radMatrix.Enable = bEnable;
	m_radWndNone.Enable = bEnable;
	/// end IMPWIZ_SUPPORT_XFUNC
	
	//int iTargetWindow = pgSource.GetCheckedRadioButton(IDC_TARGET_WKS, IDC_TARGET_WND_NONE);
	int iTargetWindow = GetCheckedRadioButton(IDC_TARGET_WKS, IDC_TARGET_WND_NONE);
	///END NOT_NEED_CALL_CONTROL
	
	//ComboBox cbWksTemplate = ImportWizDlg.GetItem(IDC_TARGET_WKS_TEMPLATE, IDD_IW_SOURCE);
	m_cbWksTemplate.Enable = (IDC_TARGET_WKS == iTargetWindow || IDC_TARGET_MATRIX == iTargetWindow);
	///END GET_IN_INITIALIZATION
}

void ImpWizSourcePage::Source_UpdateButtons()
{
	int iDisable = 1; // Disable Next & Finish buttons
	
	if( IS_DATAFROM_CLIPBOARD )
	{
		string strClipboardText;
		if( GetClipboardText(strClipboardText) )
			iDisable = 0; // Enable Next & Finish buttons
	}
	else // Data is from a file
	{
		//Edit editFileName = ImportWizDlg.GetItem(IDC_SOURCE_FILENAME, IDD_IW_SOURCE);	///Danice 12/12/03 v7.5780 GET_IN_INITIALIZATION
		string strPath = m_editFileName.Text;
		/// EJP 03-30-2004 v7.5826 QA70-6188 CHECK_FILE_FOR_READING
		/*
		if( strPath.IsFile() ) // If not valid file name
		{
			iDisable = 0; // Enable Next & Finish buttons
		}
		*/
		file filSrc;
		if( OpenExistingFile(filSrc, strPath, file::modeRead|file::typeBinary) )
		{
			filSrc.Close();
			iDisable = 0;
		}
		/// end CHECK_FILE_FOR_READING
	}
	
	///Danice 12/11/03 v7.5780 NOT_USE_DIALOG : can not use dialog here
	//ImportWizDlg.Page.Pal = iDisable; 
	m_pSheet->EnableNextBT(!iDisable);
	m_pSheet->EnableFinishBT(!iDisable);
}

void ImpWizSourcePage::Source_UpdateFilterComboBox()
{
	// Get data type setting
	///Danice 12/12/03 v7.5780 NOT_NEED_CALL_CONTROL
	//Control pgSource = ImportWizDlg.GetItem(IDD_IW_SOURCE);
	
	/// EJP 2005-08-15 v8.0288 QA70-7996 IMPWIZ_SUPPORT_XFUNC
	///	//int iFilterType = pgSource.GetCheckedRadioButton(IDC_DATATYPE_ASCII, IDC_DATATYPE_USERDEF);
	///	int iFilterType = GetCheckedRadioButton(IDC_DATATYPE_ASCII, IDC_DATATYPE_USERDEF);
	/// AW  10/30/06 v8.0503 TEMP_REMOVE_XF_FROM_IMPORT_WIZARD
	//int iFilterType = GetCheckedRadioButton(IDC_DATATYPE_ASCII, IDC_DATATYPE_XFUNC);
	int iFilterType = GetCheckedRadioButton(IDC_DATATYPE_ASCII, IDC_DATATYPE_USERDEF);
	/// END TEMP_REMOVE_XF_FROM_IMPORT_WIZARD
	/// end IMPWIZ_SUPPORT_XFUNC
	///END NOT_NEED_CALL_CONTROL
	iFilterType -= IDC_DATATYPE_ASCII;

	// Get data file name
	/*
	LPCSTR lpcszDataFile = NULL;
	Button chkCompatibleFilters = ImportWizDlg.GetItem(IDC_DISPLAY_ONLY_COMPATIBLE_CHK, IDD_IW_SOURCE);
	if( chkCompatibleFilters.Check )
	{
		if( IS_DATAFROM_FILE )
			lpcszDataFile = s_strDataFile;
	}
	*/
	string strDataFile;
	if( IS_DATAFROM_FILE )
	{
		//Button chkCompatibleFilters = ImportWizDlg.GetItem(IDC_DISPLAY_ONLY_COMPATIBLE_CHK, IDD_IW_SOURCE);	///Danice 12/12/03 v7.5780 GET_IN_INITIALIZATION
		if( m_chkCompatibleFilters.Check )
			strDataFile = s_strDataFile;
		else
			strDataFile = GetFilePath(s_strDataFile);
	}

	// Save current filter selection
	/*
	string strFilter;
	ComboBox cbFilters = ImportWizDlg.GetItem(IDC_SOURCE_FILTER, IDD_IW_SOURCE);
	int iCurSel = cbFilters.GetCurSel();
	if( iCurSel < 0 )
		iCurSel = 0;
	cbFilters.GetLBText(iCurSel, strFilter);
	*/

	// Update list
	///Source_UpdateFilterComboBoxList(iFilterType, lpcszDataFile);
	Source_UpdateFilterComboBoxList(iFilterType, strDataFile);
	
	// Update selection
	///Source_UpdateFilterComboBoxSel(iFilterType, lpcszDataFile);
	Source_UpdateFilterComboBoxSel(iFilterType, strDataFile);
}

void ImpWizSourcePage::Source_UpdateFilterComboBoxList(int iFilterType, LPCSTR lpcszDataFile)
{
	///------ Folger 04/30/09 SHARE_IMPORT_WIZARD_FILTER_LIST_CONSTRUCTION_WITH_BATCH_PROCESS_TOOL
	//StringArray saFilterFiles;
	//fuGetFilterFiles(saFilterFiles, iFilterType, lpcszDataFile);
	//
	//StringArray saFilterList;
	//fuGetFilterList(saFilterList, saFilterFiles);
	//
	////ComboBox cbFilters = ImportWizDlg.GetItem(IDC_SOURCE_FILTER, IDD_IW_SOURCE);	///Danice 12/12/03 v7.5780 GET_IN_INITIALIZATION
	//m_cbFilters.ResetContent();
	//m_cbFilters.AddString(SZ_IW_NONE);
//
	///// EJP 07-17-2003 v7.0627 QA70-4818 SAVE_FILTER_IN_WKS
	////Page pgTarget(s_strActivePageName);		///Danice CALL_SHEET_FUNCTION
	//Page pgTarget(m_pSheet->GetActivePageName());
	//if( fuIsFilterInPage(pgTarget, iFilterType) )
		//m_cbFilters.AddString(SZ_IW_PAGE_FILTER);
	///// end SAVE_FILTER_IN_WKS
	
	Page	pgTarget(m_pSheet->GetActivePageName());
	
	StringArray saFilterList;
	fuGetFilterListForImportWizard(saFilterList, iFilterType, lpcszDataFile, fuIsFilterInPage(pgTarget, iFilterType));
	
	m_cbFilters.ResetContent();
	///------ End SHARE_IMPORT_WIZARD_FILTER_LIST_CONSTRUCTION_WITH_BATCH_PROCESS_TOOL

	for( int i = 0; i < saFilterList.GetSize(); i++ )
		m_cbFilters.AddString(saFilterList[i]);
}


void ImpWizSourcePage::Source_UpdateFilterComboBoxSel(int iFilterType, LPCSTR lpcszDataFile)
{
	/// EJP 07-17-2003 v7.0627 QA70-4818 SAVE_FILTER_IN_WKS
	///int iSel = 0;
	///if( lpcszDataFile && *lpcszDataFile )
	///	iSel = Source_FindFirstCompatibleFilter(iFilterType, lpcszDataFile);
	int iSel = Source_FindFirstCompatibleFilter(iFilterType, lpcszDataFile);
	/// end SAVE_FILTER_IN_WKS
	
	//ComboBox cbFilters = ImportWizDlg.GetItem(IDC_SOURCE_FILTER, IDD_IW_SOURCE);	///Danice 12/12/03 v7.5780 GET_IN_INITIALIZATION
	m_cbFilters.SetCurSel(iSel);
}

int ImpWizSourcePage::Source_FindFirstCompatibleFilter(int iFilterType, LPCSTR lpcszDataFile)
{
	string str, strFilter;
	string strDataPath;
	if( lpcszDataFile )
		strDataPath = GetFilePath(lpcszDataFile);
	//ComboBox cbFilters = ImportWizDlg.GetItem(IDC_SOURCE_FILTER, IDD_IW_SOURCE);	///Danice 12/12/03 v7.5780 GET_IN_INITIALIZATION

	/// EJP 07-17-2003 v7.0627 QA70-4818 SAVE_FILTER_IN_WKS
	if( m_cbFilters.GetCount() <= 1 )
		return 0; // no filter
	m_cbFilters.GetLBText(1, str);
	if( 0 == str.CompareNoCase(SZ_IW_PAGE_FILTER) )
	{
		//Page pgTarget(s_strActivePageName);		///Danice CALL_SHEET_FUNCTION
		Page pgTarget(m_pSheet->GetActivePageName());
		if( fuIsFilterInPage(pgTarget, iFilterType, lpcszDataFile) )
			return 1; // use filter in page
	}
	/// end SAVE_FILTER_IN_WKS

	/// EJP 08-29-2003 v7.5680 AUTO_SELECT_ONLY_DATA_FOLDER_FILTERS
	/// This change will also cause Clipboard to auto select no filter.
	if( strDataPath.IsEmpty() )
		return 0; // no filter in data folder
	/// end AUTO_SELECT_ONLY_DATA_FOLDER_FILTERS

	for( int i = 1; i < m_cbFilters.GetCount(); i++ )
	{
		m_cbFilters.GetLBText(i, str);
		if( fuGetFilterFileNameFromListItem(str, strFilter, strDataPath) )
			/// EJP 2006-03-27 v8.0381 AUTO_SELECT_FILTER_REGADLESS_OF_LOCATION
			///	/// EJP 09-02-2003 v7.5681 AUTO_SELECT_ONLY_DATA_FOLDER_FILTERS
			///	///if( fuIsApplicable(strFilter, lpcszDataFile, iFilterType) )
			///	if( 0 == strDataPath.CompareNoCase(GetFilePath(strFilter)) && fuIsApplicable(strFilter, lpcszDataFile, iFilterType) )
			///	/// end AUTO_SELECT_ONLY_DATA_FOLDER_FILTERS
			// Per CP; when user pick a file ext, if matching filter is found, should auto
			// switch to avoid user having to pick same thing twice as user already pick
			// file ext, even it was from a diff dialog
			if( fuIsApplicable(strFilter, lpcszDataFile, iFilterType) )
			/// end AUTO_SELECT_FILTER_REGADLESS_OF_LOCATION
				return i;
	}
	return 0; // Default
}

void ImpWizSourcePage::Source_LoadCurSelFilter()
{
	//s_strFilter.Empty();	///Danice 12/15/03 v7.5783 CALL_SHEET_FUNCTION
	m_pSheet->SetFilter("");
	
	///Danice 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL
	//Control pgSource = ImportWizDlg.GetItem(IDD_IW_SOURCE);
	//int iDataType = pgSource.GetCheckedRadioButton(IDC_DATATYPE_ASCII, IDC_DATATYPE_USERDEF) - IDC_DATATYPE_ASCII;
	int iDataType = GetCheckedRadioButton(IDC_DATATYPE_ASCII, IDC_DATATYPE_USERDEF) - IDC_DATATYPE_ASCII;
	///END NOT_NEED_DIALOG_TO_CALL

	//ComboBox cbFilter = ImportWizDlg.GetItem(IDC_SOURCE_FILTER, IDD_IW_SOURCE);	///Danice 12/12/03 v7.5780 GET_IN_INITIALIZATION
	/// EJP 07-17-2003 v7.0627 QA70-4818 SAVE_FILTER_IN_WKS
	if( 0 == m_cbFilters.Text.CompareNoCase(SZ_IW_PAGE_FILTER) )
	{
		//Page pg(s_strActivePageName);			///Danice CALL_SHEET_FUNCTION
		Page pg(m_pSheet->GetActivePageName());
		fuLoadFilterFromPage(s_trFilter, pg, iDataType);
		m_pSheet->UpdateImpStructFromTree();
		//s_iSaveFilter = IDC_SAVE_FILTER_IN_WKS;	///Danice 12/15/03 v7.5783 CALL_SHEET_FUNCTION
		m_pSheet->SaveFilter(IDC_SAVE_FILTER_IN_WKS);
	}
	else
	{
		//s_iSaveFilter = IDC_SAVE_FILTER_GLOBAL_RADIO; ///Danice 12/15/03 v7.5783 CALL_SHEET_FUNCTION
		m_pSheet->SaveFilter(IDC_SAVE_FILTER_GLOBAL_RADIO);
	/// end SAVE_FILTER_IN_WKS
		if( m_cbFilters.Text.CompareNoCase(SZ_IW_NONE) )
		///Danice 12/23/03 v7.5786 VARIABLE_CHANGE
		{
			string m_strFilter = s_strFilter;
			//fuGetFilterFileNameFromListItem(m_cbFilters.Text, s_strFilter, GetFilePath(s_strDataFile));
			fuGetFilterFileNameFromListItem(m_cbFilters.Text, m_strFilter, GetFilePath(s_strDataFile));
			m_pSheet->SetFilter(m_strFilter);
		}
		///END VARIABLE_CHANGE
		///---
		
		///---Sim 06-23-2007 FIX_CHANGE_TO_BINARY_SETTING
		//m_pSheet->iwLoadFilter(s_strFilter);
		m_pSheet->iwLoadFilter(s_strFilter, iDataType);
		///---END FIX_CHANGE_TO_BINARY_SETTING
	
		if( s_strFilter.IsEmpty() ) // If no filter selected keep current Data Type setting
			/// EJP 10-27-2003 v7.5733 QA70-5238 DO_NOT_RESET_TARGET_WINDOW_TEMPLATE
			///s_trFilter.Type.nVal = iDataType;
			Source_UpdateFilter();
			/// end DO_NOT_RESET_TARGET_WINDOW_TEMPLATE
		
	/// EJP 07-18-2003 v7.0627 QA70-4818 SAVE_FILTER_IN_WKS
		else
		{
			string strDataPath = GetFilePath(s_strDataFile);
			if( 0 == strDataPath.CompareNoCase(GetFilePath(s_strFilter)) )
				//s_iSaveFilter = IDC_SAVE_FILTER_DATA_FOLDER_RADIO;	///Danice 12/15/03 v7.5783 CALL_SHEET_FUNCTION
				m_pSheet->SaveFilter(IDC_SAVE_FILTER_DATA_FOLDER_RADIO);
		}
	}
	/// end SAVE_FILTER_IN_WKS

	Source_UpdateFilter(FALSE); // FALSE = filter to dialog
}

void ImpWizSourcePage::Source_UpdateFilter(BOOL bDlgToFilter) //=TRUE)
{
	int i;
	string str;
	
	//Control pgSource = ImportWizDlg.GetItem(IDD_IW_SOURCE);	///Danice 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL

	
	///Danice 12/12/03 v7.5780 GET_IN_INITIALIZATION
	//Button chkRenameWks = ImportWizDlg.GetItem(IDC_IW_SOURCE_RENAMEWKS, IDD_IW_SOURCE);
	//Button chkFileNameToWksLabel = ImportWizDlg.GetItem(IDC_IW_FILENAME_TO_WKSLABEL, IDD_IW_SOURCE);
	//Button chkWks = ImportWizDlg.GetItem(IDC_TARGET_WKS, IDD_IW_SOURCE);
	//ComboBox cbWksTemplate = ImportWizDlg.GetItem(IDC_TARGET_WKS_TEMPLATE, IDD_IW_SOURCE);
	//Button chkMat = ImportWizDlg.GetItem(IDC_TARGET_MATRIX, IDD_IW_SOURCE);
	///END GET_IN_INITIALIZATION
	
	if( bDlgToFilter )
	{
		/// EJP 2005-08-15 v8.0288 QA70-7996 IMPWIZ_SUPPORT_XFUNC
		///	///Danice 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL
		///	//s_trFilter.Type.nVal = pgSource.GetCheckedRadioButton(IDC_DATATYPE_ASCII, IDC_DATATYPE_USERDEF) - IDC_DATATYPE_ASCII;
		///	s_trFilter.Type.nVal = GetCheckedRadioButton(IDC_DATATYPE_ASCII, IDC_DATATYPE_USERDEF) - IDC_DATATYPE_ASCII;
		/// Hong 8/31/06 GET_FILTER_BY_ID
		//s_trFilter.Type.nVal = GetCheckedRadioButton(IDC_DATATYPE_ASCII, IDC_DATATYPE_XFUNC) - IDC_DATATYPE_ASCII;
		/// AW  10/30/06 v8.0503 TEMP_REMOVE_XF_FROM_IMPORT_WIZARD
		//int nType = GetCheckedRadioButton(IDC_DATATYPE_ASCII, IDC_DATATYPE_XFUNC) - IDC_DATATYPE_ASCII;
		int nType = GetCheckedRadioButton(IDC_DATATYPE_ASCII, IDC_DATATYPE_USERDEF) - IDC_DATATYPE_ASCII;
		/// END TEMP_REMOVE_XF_FROM_IMPORT_WIZARD
		fuSetType(s_trFilter, nType);
		/// end GET_FILTER_BY_ID
		/// end IMPWIZ_SUPPORT_XFUNC
		
		/// EJP 11-11-2004 v8.0163 QA70-6554 EXTRACT_VARS_FROM_FILENAME
		/*
		s_trFilter.Common.RenameWks.nVal = (m_chkRenameWks.Check ? 1 : 0);
		s_trFilter.Common.FileNameToWksLabel.nVal = (m_chkFileNameToWksLabel.Check ? 1 : 0);

		/// EJP 07-19-2004 v8.0911 QA70-6555 SUPPORT_WORKBOOK_IMPWIZ
		DWORD dwFlags = 0;
		if( m_chkRenWkbk.Check )
			dwFlags |= AI_FLAG_FNAME_TO_WKBK_NAME;
		if( m_chkFNameToWkbkComments.Check )
			dwFlags |= AI_FLAG_FNAME_TO_WKBK_COMMENTS;
		if( m_chkFNameToColComments.Check )
			dwFlags |= AI_FLAG_FNAME_TO_COL_COMMENTS;
		if( !m_chkIncludePath.Check )
			dwFlags |= AI_FLAG_REMOVE_FNAME_PATH;
		s_trFilter.Common.Flags.nVal = dwFlags;
		/// end SUPPORT_WORKBOOK_IMPWIZ
		*/
		/// end EXTRACT_VARS_FROM_FILENAME

		//int iType = pgSource.GetCheckedRadioButton(IDC_TARGET_WKS, IDC_TARGET_WND_NONE);
		int iType = GetCheckedRadioButton(IDC_TARGET_WKS, IDC_TARGET_WND_NONE);
		switch( iType )
		{
		case IDC_TARGET_WKS:
			str = m_cbWksTemplate.Text;
			iType = EXIST_WKS;
			break;
		case IDC_TARGET_MATRIX:
			str = m_cbWksTemplate.Text;
			iType = EXIST_MATRIX;
			break;
		case IDC_TARGET_WND_NONE:
			str.Empty();
			iType = EXIST_NONE;
			break;
		}
		if( 0 == str.CompareNoCase(SZ_IW_DEFAULT) )
			str.Empty(); // store empty string to indicate default
		fuSetTargetPage(s_trFilter, iType, str);

		/// EJP 01-07-2005 v8.0183 QA70-6555 NEW_IMPORT_MODES
		i = m_cbImportMode.GetCurSel();
		/// Hong 04/10/07 v8.697b REMOVE_AUTO_IMPORT_MODE
		//fuSetImportMode(IW_FILTER, GetImportModeFromListIndex(i));
		fuSetImportMode(IW_FILTER, GetImportModeFromListIndex(i+1));
		/// Hong 05/23/07 v8.0623 KEEP_ORIGIN_IMPORT_MODE
		fuSet1stImportMode(IW_FILTER, GetImportModeFromListIndex(i+1));
		/// end KEEP_ORIGIN_IMPORT_MODE
		/// end REMOVE_AUTO_IMPORT_MODE
		/// end NEW_IMPORT_MODES
		
		/// EJP 2005-08-16 v8.0289 QA70-7996 IMPWIZ_SUPPORT_XFUNC
		/// AW  10/30/06 v8.0503 TEMP_REMOVE_XF_FROM_IMPORT_WIZARD
		/*
		i = m_cbXFuncs.GetCurSel();
		m_cbXFuncs.GetLBText(i, str);
		str = okutil_separate_composite_name(str);/// EJP 2006-06-29 v8.0434 ONLY_PUT_XFUNC_NAME_INTO_FILTER
		fuSetXFunctionName(s_trFilter, str);
		*/
		/// END TEMP_REMOVE_XF_FROM_IMPORT_WIZARD
		/// end IMPWIZ_SUPPORT_XFUNC
	}
	else // update dialog from filter
	{
		//i = tree_node_get_int(s_trFilter.Type, FILTER_TYPE_ASCII);
		i = fuGetInt(s_trFilter, IDE_DISP_IMP_TYPE, FILTER_TYPE_ASCII);//Hong 8/31/06 GET_FILTER_BY_ID
		/// EJP 2005-08-15 v8.0288 QA70-7996 IMPWIZ_SUPPORT_XFUNC
		///	//pgSource.CheckRadioButton(IDC_DATATYPE_ASCII, IDC_DATATYPE_USERDEF, IDC_DATATYPE_ASCII + i);
		///	CheckRadioButton(IDC_DATATYPE_ASCII, IDC_DATATYPE_USERDEF, IDC_DATATYPE_ASCII + i);
		CheckRadioButton(IDC_DATATYPE_ASCII, IDC_DATATYPE_USERDEF, IDC_DATATYPE_ASCII + i);
		/// end IMPWIZ_SUPPORT_XFUNC
		
		/// EJP 2005-08-22 v8.0292 QA70-7996 IMPWIZ_SUPPORT_XFUNC
		/// AW  10/30/06 v8.0503 TEMP_REMOVE_XF_FROM_IMPORT_WIZARD
		//m_cbXFuncs.Enable = (i == FILTER_TYPE_XFUNC);
		/// END TEMP_REMOVE_XF_FROM_IMPORT_WIZARD
		/// end IMPWIZ_SUPPORT_XFUNC

		/// EJP 11-11-2004 v8.0163 QA70-6554 EXTRACT_VARS_FROM_FILENAME
		/*
		m_chkRenameWks.Check = tree_node_get_int(s_trFilter.Common.RenameWks, 0);
		m_chkFileNameToWksLabel.Check = tree_node_get_int(s_trFilter.Common.FileNameToWksLabel, 1);

		/// EJP 07-19-2004 v8.0911 QA70-6555 SUPPORT_WORKBOOK_IMPWIZ
		DWORD dwFlags = tree_node_get_int(s_trFilter.Common.Flags, 0);
		m_chkRenWkbk.Check = dwFlags & AI_FLAG_FNAME_TO_WKBK_NAME;
		m_chkFNameToWkbkComments.Check = dwFlags & AI_FLAG_FNAME_TO_WKBK_COMMENTS;
		m_chkFNameToColComments.Check = dwFlags & AI_FLAG_FNAME_TO_COL_COMMENTS;
		m_chkIncludePath.Check = dwFlags & AI_FLAG_REMOVE_FNAME_PATH;
		/// end SUPPORT_WORKBOOK_IMPWIZ
		*/
		/// end EXTRACT_VARS_FROM_FILENAME

		i = fuGetTargetPage(s_trFilter, str);
		switch( i )
		{
		case EXIST_MATRIX:
			i = IDC_TARGET_MATRIX;
			break;
		case EXIST_WKS:
			i = IDC_TARGET_WKS;
			break;
		case EXIST_NONE:
			i = IDC_TARGET_WND_NONE;
			break;
		}
		//pgSource.CheckRadioButton(IDC_TARGET_WKS, IDC_TARGET_WND_NONE, i);
		CheckRadioButton(IDC_TARGET_WKS, IDC_TARGET_WND_NONE, i);
		///END NOT_NEED_DIALOG_TO_CALL
		m_cbWksTemplate.SetCurSel(0);
		m_cbWksTemplate.SelectString(-1, str);

		Source_EnableTargetWindowCtrls();
		
		/// EJP 09-24-2003 v7.5706 QA70-4073.55 ADD_FILTER_DESCRIPTION
		str.Empty();
		fuGetDescription(s_trFilter, str);
		//Edit ebDescrip = ImportWizDlg.GetItem(IDC_FILTER_DESCRIP, IDD_IW_SOURCE);	///Danice 12/12/03 v7.5780 GET_IN_INITIALIZATION
		m_ebDescrip.Text = str;
		/// end ADD_FILTER_DESCRIPTION

		/// EJP 01-07-2005 v8.0183 QA70-6555 NEW_IMPORT_MODES
		/// Hong 05/23/07 v8.0623 KEEP_ORIGIN_IMPORT_MODE
		//i = fuGetImportMode(IW_FILTER);
		i = fuGet1stImportMode(IW_FILTER);
		/// end KEEP_ORIGIN_IMPORT_MODE
		/// Hong 04/10/07 v8.697b REMOVE_AUTO_IMPORT_MODE
		//m_cbImportMode.SetCurSel(GetListIndexFromImportMode(i));
		///---Sim 05-30-2007 FIX_IMPORT_MODE
		//m_cbImportMode.SetCurSel(GetListIndexFromImportMode(i-1));
		m_cbImportMode.SetCurSel(GetListIndexFromImportMode(i)-1);
		///---END FIX_IMPORT_MODE
		/// end REMOVE_AUTO_IMPORT_MODE
		/// end NEW_IMPORT_MODES
		
		/// EJP 2005-08-16 v8.0289 QA70-7996 IMPWIZ_SUPPORT_XFUNC
		fuGetXFunctionName(s_trFilter, str);
		/// AW  10/30/06 v8.0503 TEMP_REMOVE_XF_FROM_IMPORT_WIZARD
		//m_cbXFuncs.SelectString(-1, str);
		/// END TEMP_REMOVE_XF_FROM_IMPORT_WIZARD
		/// end IMPWIZ_SUPPORT_XFUNC
		
	}
}


BOOL ImpWizSourcePage::OnActiveSource()
{
	Source_UpdateButtons();

	/// EJP 06-08-2004 v8.0886 QA70-5417 IMPROVE_DATA_CHANGE_DETECTION
	if( IS_DATAFROM_CLIPBOARD )
		m_nDataSourceOnActive = IDC_SOURCE_CLIPBOARD;
	else
		m_nDataSourceOnActive = IDC_SOURCE_FILE;
	m_strDataFileOnActive = m_editFileName.Text;
	/// end IMPROVE_DATA_CHANGE_DETECTION
	
	return TRUE;
}


BOOL ImpWizSourcePage::OnKillActive_Source()
{
	Source_UpdateFilter();
	m_pSheet->UpdateImpStructFromTree();//Hong 9/05/06 UPDATE_ASCIMP_AND_BINIMP
	/// EJP 08-15-2003 v7.5661 QA70-4073.58 CLEAN_IMPORT_FROM_CLIPBOARD
	/*
	if( IS_DATAFROM_CLIPBOARD )
	{
		// Copy clipboard text into local string
		string strClipboardText;
		GetClipboardText(strClipboardText);

		// Get a temporary file name
		AIW_GetTempFileName(s_strDataFile);
		
		// Write clipboard text to temporary file
		stdioFile filTemp(s_strDataFile, file::modeCreate | file::modeWrite | file::shareExclusive | file::typeText );
		filTemp.WriteString(strClipboardText);
		filTemp.Close();
	}
	else // Data is from a file
	{
		Edit editFileName = ImportWizDlg.GetItem(IDC_SOURCE_FILENAME, IDD_IW_SOURCE);
		s_strDataFile = editFileName.Text;
	}
	*/
	/// end CLEAN_IMPORT_FROM_CLIPBOARD

	////////////////////////////////////////////////////////////////////////
	// Create a worksheet
	////////////////////////////////////////////////////////////////////////
	Worksheet wks;
	///Danice 12/15/03 v7.5783 CALL_SHEET_FUNCTION
	string s_strWks2 = m_pSheet->GetWksName();
	if( !s_strWks2.IsEmpty() )
	{
		// If we already created a wks then delete it
		wks.Attach(s_strWks2);
		/// SY 10/08/2004 CORRECT_DELETE_WKS_IN_80
		///wks.Destroy();
		wks.GetPage().Destroy();
		/// end CORRECT_DELETE_WKS_IN_80
		//s_strWks.Empty();
		m_pSheet->SetWksName("");
	}
	///END ACCOMPLISH_IN_SHEET

#ifdef IW_DEBUG
	int nOption = CREATE_VISIBLE;
#else // !IW_DEBUG
	///---Sim 06-04-2007 SOME_PAGES_TO_BE_EXCLUDED_FROM_MANAGER
	//int nOption = CREATE_HIDDEN;
	int nOption = CREATE_SET_MISSING_IN_MANAGER;
	///---END SOME_PAGES_TO_BE_EXCLUDED_FROM_MANAGER
#endif // !IW_DEBUG
	//ComboBox comboTemplate = ImportWizDlg.GetItem(IDC_TARGET_WKS_TEMPLATE);	///Danice 12/12/03 v7.5780 NOT_NEED_CALL_BY_DIALOG
	ComboBox comboTemplate = GetItem(IDC_TARGET_WKS_TEMPLATE);

	if( comboTemplate.GetCurSel() == 0 )
		wks.Create(NULL, nOption);
	else
	{
		string strTemplate = comboTemplate.Text + ".otw";
		wks.Create(strTemplate, nOption);
	}

	//wks.GetPage().GetName(s_strWks);
	wks.GetPage().GetName(s_strWks2);
	m_pSheet->SetWksName(s_strWks2);
	
	BOOL bFilterRepetitive = fuGetRepetitive(s_trFilter);
	wks.SetColDesignations(fuGetDesignations(s_trFilter), bFilterRepetitive);
	wks.SetColFormats(fuGetFormats(s_trFilter), bFilterRepetitive);

	///Danice 12/15/03 V7.5783 CALL_SHEET_FUNCTION
	/*if( EXIST_PLOT == s_iActivePageType )
	{
		s_vPlottingLayers.SetSize(0);
		for( int i = 0; i < s_saDataFiles.GetSize(); i++ )
			s_vPlottingLayers.Add(0); // 0=first layer
	}*/
	if( EXIST_PLOT == m_pSheet->GetActivePageType() )
		m_pSheet->AddPlottingLayers();
	///END CALL_SHEET_FUNCTION

	/// EJP 06-08-2004 v8.0886 QA70-5417 IMPROVE_DATA_CHANGE_DETECTION
	int nDataSourceOnKill;
	if( IS_DATAFROM_CLIPBOARD )
		nDataSourceOnKill = IDC_SOURCE_CLIPBOARD;
	else
		nDataSourceOnKill = IDC_SOURCE_FILE;

	string strDataFileOnKill = m_editFileName.Text;
	
	/// Hong 9/18/06 FIX_MISUPDATE_DATA_IN_HEADER_LINE_PAGE
	/*
	if( (nDataSourceOnKill != m_nDataSourceOnActive) || (IS_DATAFROM_FILE && strDataFileOnKill.CompareNoCase(m_strDataFileOnActive)) )
		/// EJP 2005-11-21 v8.0340 FOR_CONTROL_UPGRADE_DATA
		///m_pSheet->IsUpgradeData(true);
		m_pSheet->UpgradeData();
		/// end FOR_CONTROL_UPGRADE_DATA
	*/
	m_pSheet->UpgradeData();
	/// end FIX_MISUPDATE_DATA_IN_HEADER_LINE_PAGE
	/// end IMPROVE_DATA_CHANGE_DETECTION

	return TRUE;
}

BOOL ImpWizSourcePage::OnClickDataType_Source(Control Cntrl)
{
	///Danice 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL
	//Control pgSource = ImportWizDlg.GetItem(IDD_IW_SOURCE);
	/// EJP 2005-08-15 v8.0288 QA70-7996 IMPWIZ_SUPPORT_XFUNC
	///	//int iType = pgSource.GetCheckedRadioButton(IDC_DATATYPE_ASCII, IDC_DATATYPE_USERDEF) - IDC_DATATYPE_ASCII;
	///	int iType = GetCheckedRadioButton(IDC_DATATYPE_ASCII, IDC_DATATYPE_USERDEF) - IDC_DATATYPE_ASCII;
	/// AW  10/30/06 v8.0503 TEMP_REMOVE_XF_FROM_IMPORT_WIZARD
	//int iType = GetCheckedRadioButton(IDC_DATATYPE_ASCII, IDC_DATATYPE_XFUNC) - IDC_DATATYPE_ASCII;
	int iType = GetCheckedRadioButton(IDC_DATATYPE_ASCII, IDC_DATATYPE_USERDEF) - IDC_DATATYPE_ASCII;
	/// END TEMP_REMOVE_XF_FROM_IMPORT_WIZARD
	/// end IMPWIZ_SUPPORT_XFUNC
	///END NOT_NEED_DIALOG_TO_CALL
	/// EJP 2005-08-22 v8.0292 QA70-7996 IMPWIZ_SUPPORT_XFUNC
	/// AW  10/30/06 v8.0503 TEMP_REMOVE_XF_FROM_IMPORT_WIZARD
	//m_cbXFuncs.Enable = (iType == FILTER_TYPE_XFUNC);
	/// END TEMP_REMOVE_XF_FROM_IMPORT_WIZARD
	/// end IMPWIZ_SUPPORT_XFUNC
	
	///Danice 1/17/04 v8.0802 FOR_CONTROL_UPGRADE_DATA
	//if(s_trFilter.Type.nVal != iType)
	if(fuGetType(s_trFilter) != iType)//Hong 8/31/06 GET_FILTER_BY_ID
	{
		//fuPrepareDefault(s_trFilter, iType);//Hong 8/28/06 UPDATE_FILTER
		/// EJP 06-08-2004 v8.0886 QA70-5417 IMPROVE_DATA_CHANGE_DETECTION
		///m_pSheet->IsUpgradeData(true);
		/// end IMPROVE_DATA_CHANGE_DETECTION

		//s_trFilter.Type.nVal = iType;
		//fuSetType(s_trFilter, iType);//Hong 8/31/06 GET_FILTER_BY_ID
		
		Source_EnableDataSourceCtrls();
		Source_EnableTargetWindowCtrls();
		Source_UpdateFilterComboBox();
		Source_LoadCurSelFilter();
		Source_UpdateTargetWindowTemplateList();
		Source_UpdateButtons();
	}
	///END FOR_CONTROL_UPGRADE_DATA
	return TRUE;
}

BOOL ImpWizSourcePage::OnClickDataFrom_Source(Control ctrl)
{
	/// EJP 08-15-2003 v7.5661 QA70-4073.58 CLEAN_IMPORT_FROM_CLIPBOARD
	if( IS_DATAFROM_CLIPBOARD )
		DeleteFile(s_strDataFile); // delete temporary file
	/// end CLEAN_IMPORT_FROM_CLIPBOARD

	//Button radioClipboard = ImportWizDlg.GetItem(IDC_SOURCE_CLIPBOARD, IDD_IW_SOURCE);	///Danice 12/12/03 v7.5780 NOT_NEED_DIALOG_TO_CALL
	Button radioClipboard = GetItem(IDC_SOURCE_CLIPBOARD);
	if( radioClipboard.Check )
	{
		SET_DATAFROM_CLIPBOARD;

		/// EJP 08-15-2003 v7.5661 QA70-4073.58 CLEAN_IMPORT_FROM_CLIPBOARD
		// Copy clipboard text into local string
		string strClipboardText;
		GetClipboardText(strClipboardText);

		///Danice 12/26/03 v7.5789 SAVE_CHANGE
		// Get a temporary file name
		string m_strDataFile_TEMP = s_strDataFile;
		m_pSheet->AIW_GetTempFileName(m_strDataFile_TEMP);
		m_pSheet->SetFileName(m_strDataFile_TEMP);
		///END SAVE_CHANGE
		
		// Write clipboard text to temporary file
		stdioFile filTemp(s_strDataFile, file::modeCreate | file::modeWrite | file::shareExclusive | file::typeText );
		filTemp.WriteString(strClipboardText);
		filTemp.Close();
		/// end CLEAN_IMPORT_FROM_CLIPBOARD		
	}
	else
	{
		SET_DATAFROM_FILE;

		/// EJP 08-15-2003 v7.5661 QA70-4073.58 CLEAN_IMPORT_FROM_CLIPBOARD
		//Edit editFileName = ImportWizDlg.GetItem(IDC_SOURCE_FILENAME, IDD_IW_SOURCE);	///Danice 12/12/03 v7.5780 GET_IN_INITIALIZATION
		//s_strDataFile = m_editFileName.Text;	///Danice 12/15/03 v7.5783 CALL_SHEET_FUNCTION
		m_pSheet->SetFileName(m_editFileName.Text);
		/// end CLEAN_IMPORT_FROM_CLIPBOARD
	}

	Source_EnableFileCtrls(IS_DATAFROM_FILE);
	Source_UpdateFilterComboBox();
	Source_LoadCurSelFilter();
	Source_UpdateButtons();
	
	/// Hong 11/01/07 v8.0738b DISALBE_RENAME_FOR_CLIPBOARD
	if( radioClipboard.Check )
		fuDisableAllRename(IW_FILTER);
	/// end DISALBE_RENAME_FOR_CLIPBOARD	
	return TRUE;
}


BOOL ImpWizSourcePage::OnClickBrowse_Source(Control ctrl)
{
	ENABLE_ON_BROWSE_SOURCE; /// EJP 10-16-2003 v7.5722 QA70-5289.7 UPDATE_SOURCE_FILE_ON_EDIT_CHANGE

	///Danice 12/12/03 v7.5780 NOT_NEED_CALL_CONTROL
	//Control pgSource = ImportWizDlg.GetItem(IDD_IW_SOURCE);
	/// EJP 2005-08-16 v8.0289 QA70-7996 IMPWIZ_SUPPORT_XFUNC
	///	//int nDataType = pgSource.GetCheckedRadioButton(IDC_DATATYPE_ASCII, IDC_DATATYPE_USERDEF);
	///	int nDataType = GetCheckedRadioButton(IDC_DATATYPE_ASCII, IDC_DATATYPE_USERDEF);
	/// AW  10/30/06 v8.0503 TEMP_REMOVE_XF_FROM_IMPORT_WIZARD
	//int nDataType = GetCheckedRadioButton(IDC_DATATYPE_ASCII, IDC_DATATYPE_XFUNC);
	int nDataType = GetCheckedRadioButton(IDC_DATATYPE_ASCII, IDC_DATATYPE_USERDEF);
	/// END TEMP_REMOVE_XF_FROM_IMPORT_WIZARD
	/// end IMPWIZ_SUPPORT_XFUNC
	///END NOT_NEED_CALL_CONTROL
	
	nDataType -= IDC_DATATYPE_ASCII;

	StringArray saDataFiles;
	/// SY 01/04/2005 QA70-6555 v8.0181 USING_MULTI_OPEN_FDLOG
	///if( GetMultiOpenBox(saDataFiles, nDataType + FDLOG_FILTER_ASCII) )
	if( GetMultiOpenBox(saDataFiles, nDataType + FDLOG_FILTER_ASCII, NULL, NULL, NULL, false) )
	/// end USING_MULTI_OPEN_FDLOG
	{
		/// EJP 01-04-2005 v8.0181 QA70-6555 USING_MULTI_OPEN_FDLOG
		SetComboBoxItems(m_editFileName, saDataFiles);
		m_editFileName.SetCurSel(0); // select first file
		/// end USING_MULTI_OPEN_FDLOG
		
		/// EJP 06-08-2004 v8.0886 QA70-5417 IMPROVE_DATA_CHANGE_DETECTION
		///	///Danice 1/17/04 v8.0802 FOR_CONTROL_UPGRADE_DATA
		///	if(saDataFiles[0].Compare(m_pSheet->GetFileName()))
		///	{
		///		m_pSheet->IsUpgradeData(true);
		///	}
		///	///END FOR_CONTROL_UPGRADE_DATA
		/// end IMPROVE_DATA_CHANGE_DETECTION
		
		///Danice 12/15/03 v7.5783 CALL_SHEET_FUNCTION
		//s_saDataFiles = saDataFiles;
		m_pSheet->SetFileNames(saDataFiles);
		///END CALL_SHEET_FUNCTION

		/// EJP 01-04-2005 v8.0181 QA70-6555 USING_MULTI_OPEN_FDLOG
		///	//Edit editFileName = ImportWizDlg.GetItem(IDC_SOURCE_FILENAME, IDD_IW_SOURCE);	///Danice 12/12/03 v7.5780 GET_IN_INITIALIZATION
		///	//m_editFileName.Text = s_saDataFiles[0];	///Danice 12/15/03 v7.5783 DATAFILENAME_REPLACE
		///	m_editFileName.Text = saDataFiles[0];
		///	/// EJP 06-26-2003: setting editFileName.Text will trigger a call to Source_OnChangeFileName
		///	///Source_UpdateButtons();
		///	///Source_SelectFilterOnChangeFileName();
		Source_UpdateButtons();
		Source_UpdateFilterComboBox();
		Source_LoadCurSelFilter();
		/// end USING_MULTI_OPEN_FDLOG
	}
	
	DISABLE_ON_BROWSE_SOURCE; /// EJP 10-16-2003 v7.5722 QA70-5289.7 UPDATE_SOURCE_FILE_ON_EDIT_CHANGE
	return TRUE;
}

/// EJP 11-11-2004 v8.0163 QA70-6554 EXTRACT_VARS_FROM_FILENAME
/*
BOOL ImpWizSourcePage::OnClickRenameWks_Source(Control ctrl)
{
	//Button chkRenameWks = ImportWizDlg.GetItem(IDC_IW_SOURCE_RENAMEWKS, IDD_IW_SOURCE);	///Danice 12/12/03 v7.5780 GET_IN_INITIALIZATION
	s_trFilter.Common.RenameWks.nVal = m_chkRenameWks.Check;
	return TRUE;
}	

BOOL ImpWizSourcePage::OnClickFileNameToWksLabel_Source(Control ctrl)
{
	//Button chkFileNameToWksLabel = ImportWizDlg.GetItem(IDC_IW_FILENAME_TO_WKSLABEL, IDD_IW_SOURCE);	///Danice 12/12/03 v7.5780 GET_IN_INITIALIZATION
	s_trFilter.Common.FileNameToWksLabel.nVal = m_chkFileNameToWksLabel.Check;
	return TRUE;
}

/// EJP 07-19-2004 v8.0911 QA70-6555 SUPPORT_WORKBOOK_IMPWIZ
BOOL ImpWizSourcePage::OnClickRenameWorkbook(Control ctrl)
{
	if( m_chkRenWkbk.Check ) 
		s_trFilter.Common.Flags.nVal |= AI_FLAG_FNAME_TO_WKBK_NAME;
	else
		s_trFilter.Common.Flags.nVal &= ~AI_FLAG_FNAME_TO_WKBK_NAME;
	return TRUE;
}

BOOL ImpWizSourcePage::OnClickFileNameToColComments(Control ctrl)
{
	if( m_chkFNameToColComments.Check ) 
		s_trFilter.Common.Flags.nVal |= AI_FLAG_FNAME_TO_COL_COMMENTS;
	else
		s_trFilter.Common.Flags.nVal &= ~AI_FLAG_FNAME_TO_COL_COMMENTS;
	return TRUE;
}

BOOL ImpWizSourcePage::OnClickIncludeFileNamePath(Control ctrl)
{
	if( m_chkIncludePath.Check ) 
		s_trFilter.Common.Flags.nVal &= ~AI_FLAG_REMOVE_FNAME_PATH;
	else
		s_trFilter.Common.Flags.nVal |= AI_FLAG_REMOVE_FNAME_PATH;
	return TRUE;
}
/// end SUPPORT_WORKBOOK_IMPWIZ
*/
/// end EXTRACT_VARS_FROM_FILENAME

BOOL ImpWizSourcePage::OnChangeFileName_Source(Control ctrl) 
{
	/// EJP 10-16-2003 v7.5722 QA70-5289.7 UPDATE_SOURCE_FILE_ON_EDIT_CHANGE
	if( !IS_ON_BROWSE_SOURCE )
	{
		//Edit editFileName = ImportWizDlg.GetItem(IDC_SOURCE_FILENAME, IDD_IW_SOURCE);	///Danice 12/12/03 v7.5780 GET_IN_INITIALIZATION
		///Danice 12/15/03 v7.5783 CALL_SHEET_FUNCTION
		//s_saDataFiles[0] = m_editFileName.Text;
		m_pSheet->SetFileName(m_editFileName.Text);
		//END
		m_bFileNameChanged = true; /// SY 01/06/2005 v8.0183 QA70-6555 USING_MULTI_OPEN_FDLOG
	}
	/// end UPDATE_SOURCE_FILE_ON_EDIT_CHANGE

	Source_UpdateButtons();
	Source_UpdateFilterComboBox();
	Source_LoadCurSelFilter();
	return TRUE;
}

/// EJP 01-04-2005 v8.0181 QA70-6555 NEW_IMPORT_MODES
BOOL ImpWizSourcePage::OnSelChangeFileName(Control ctrl)
{
	int nIndex = m_editFileName.GetCurSel();
	m_pSheet->SetFileName(nIndex);
	Source_UpdateButtons();
	return TRUE;
}
/// end NEW_IMPORT_MODES

/// SY 01/06/2005 v8.0183 QA70-6555 USING_MULTI_OPEN_FDLOG
BOOL ImpWizSourcePage::OnDropDownFileName(Control ctrl)
{
	if( m_bFileNameChanged )
	{
		string str = m_editFileName.Text;
		
		// Update file name ComboBox
		int nIndex = m_pSheet->GetActiveDataFile();
		
		m_editFileName.DeleteString(nIndex);
		m_editFileName.InsertString(nIndex, str);
		
		m_bFileNameChanged = false;
	}
	return TRUE;
}
/// end USING_MULTI_OPEN_FDLOG


BOOL ImpWizSourcePage::OnClickTargetWindow_Source(Control ctrl)
{
	Source_UpdateTargetWindowTemplateList();
	Source_EnableTargetWindowCtrls();
	return TRUE;
}

BOOL ImpWizSourcePage::OnSelChangeTargetWindowTemplate_Source(Control ctrl)
{
	ComboBox cbTemplate2(ctrl);
	if( !cbTemplate2 )
		return FALSE;
	string strTemplate;
	int iWindowType = Source_GetTargetWindowType();
	if( iWindowType != EXIST_NONE && m_cbWksTemplate.GetCurSel() > 0 )
		strTemplate = cbTemplate2.Text;
	fuSetTargetPage(s_trFilter, iWindowType, strTemplate);
	return TRUE;
}

BOOL ImpWizSourcePage::OnClickDisplayCompatibleFilters_Source(Control ctrl)
{
	Source_UpdateFilterComboBox();
	/// Hong 03/23/09 FIX_FILTER_NOT_RELOADED_EVEN_COMBO_HAVE_CHANGED_WHEN_CLICK_DISPLAY_COMPATIBLE_BTN
	Source_LoadCurSelFilter();
	/// end FIX_FILTER_NOT_RELOADED_EVEN_COMBO_HAVE_CHANGED_WHEN_CLICK_DISPLAY_COMPATIBLE_BTN
	return TRUE;
}

//--------------------------------------------------------------------------
// Source_OnSelChangeFilter
//
// DialogBuilder calls this function when the selection in the filter
// combobox is changed.
//--------------------------------------------------------------------------
bool ImpWizSourcePage::OnSelChangeFilter_Source(Control ctrl)
{
	Source_LoadCurSelFilter();
	return TRUE;
}

void ImpWizSourcePage::Source_UpdateTargetWindowTemplateList()
{
	int iTargetWindowType = Source_GetTargetWindowType();
	if( iTargetWindowType == EXIST_NONE )
		return;
	//ComboBox cbTemplate = ImportWizDlg.GetItem(IDC_TARGET_WKS_TEMPLATE, IDD_IW_SOURCE);	///Danice 12/12/03 v7.5780 GET_IN_INITIALIZATION
	m_pSheet->InitComboBoxWithTemplateNames(m_cbWksTemplate, iTargetWindowType);
}

int ImpWizSourcePage::Source_GetTargetWindowType()
{
	///Danice 12/12/03 v7.5780 NOT_NEED_CALL_CONTROL
	//Control pgSource = ImportWizDlg.GetItem(IDD_IW_SOURCE);
	//int iTargetWindow = pgSource.GetCheckedRadioButton(IDC_TARGET_WKS, IDC_TARGET_WND_NONE);
	int iTargetWindow = GetCheckedRadioButton(IDC_TARGET_WKS, IDC_TARGET_WND_NONE);
	///END NOT_NEED_CALL_CONTROL
	switch( iTargetWindow )
	{
	case IDC_TARGET_WKS:
		iTargetWindow = EXIST_WKS;
		break;
	case IDC_TARGET_MATRIX:
		iTargetWindow = EXIST_MATRIX;
		break;
	default:
		iTargetWindow = EXIST_NONE;
		break;
	}
	return iTargetWindow;
}

///------ Folger 10/19/2010 ORG-1279 DIALOG_DISPLAY_NOT_GOOD_IN_CHINESE
void	ImpWizSourcePage::CheckResizeFilterControl()
{
	Control		ctrlFilterText = GetItem(IDC_SOURCE_FILTER_TEXT);
	if ( ctrlFilterText )
	{
		RECT	rr;
		ctrlFilterText.GetWindowRect(&rr);
		ScreenToClient(&rr);
		
		int		nWidth;
		ctrlFilterText.Measure(ctrlFilterText.Text, &nWidth, TRUE);
		if ( nWidth > RECT_WIDTH(rr) )
		{
			int		nn = nWidth - RECT_WIDTH(rr);
			rr.right += nn;
			ctrlFilterText.MoveWindow(&rr);

			m_cbFilters.GetWindowRect(&rr);
			ScreenToClient(&rr);
			rr.left += nn;
			m_cbFilters.MoveWindow(&rr);
		}
	}
}
///------ End DIALOG_DISPLAY_NOT_GOOD_IN_CHINESE

/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
/**************************************************************************/

/// EJP 11-11-2004 v8.0163 QA70-6554 EXTRACT_VARS_FROM_FILENAME
DWORD IWFileNameOptionsPage::OnShowStatus(DWORD InternalStatus)
{
	if( IsFlagEnabled(FLAG_DATAFROM_CLIPBOARD) )
		return PSS_Ignore;
	return PSS_Show;
}

BOOL IWFileNameOptionsPage::OnInit()
{
	m_chkAutoRename = GetItem(IDC_AUTO_RENAME); ///---Sim 02-01-2007 ADD_AUTO_RENAME
	m_chkRenWksToFName = GetItem(IDC_REN_WKS_TO_FILE_NAME);
	/// Hong 02/27/07 QA80-9410 MORE_RENAME_WORKSHEET_WITH_VARIABLE
	//m_chkRenWkbkToFirstVar	= GetItem(IDC_REN_WKS_TO_FIRST_VARIABLE); // Hong 02/26/07 ADD_WORKSHEET_TO_FIRST_VARIABLE
	m_chkRenWksWithVar	= GetItem(IDC_REN_WKS_TO_VARIABLE);
	m_ebWksVarName		= GetItem(IDC_REN_WKS_VARIABLE_NAME);
	/// end MORE_RENAME_WORKSHEET_WITH_VARIABLE
	m_chkRenWkbkToFName = GetItem(IDC_REN_WKBK_TO_FILE_NAME);
	///---Sim 03-06-2007 MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF
	m_chkRenWkbkWithVar	= GetItem(IDC_REN_WKBK_TO_VARIABLE);
	m_ebWkbkVarName		= GetItem(IDC_REN_WKBK_VARIABLE_NAME);
	///---END MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF
	m_chkRenWkbkLnOnly = GetItem(IDC_REN_WKBK_LONG_NAME_ONLY); ///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
	m_chkRenWkbkFPath = GetItem(IDC_RENAME_FILE_PATH); ///---Sim 02-25-2007 ADD_OPTION_FILE_PATH_FOR_WORKBOOK
	m_chkAppendFNameToWkbkComm = GetItem(IDC_APPEND_FILE_NAME_TO_WKS_COMM);
	m_chkAppendFNameToColComm = GetItem(IDC_APPEND_FILE_NAME_TO_COL_COMM);
	m_chkAppendFPath = GetItem(IDC_APPEND_FILE_PATH);

	m_grpExtractVar = GetItem(IDC_EXTRACT_VAR_GRP);
	m_chkExtractByDelim = GetItem(IDC_EXTRACT_BY_DELIM);
	m_chkExtractByPos = GetItem(IDC_EXTRACT_BY_POS);

	return TRUE;
}

BOOL IWFileNameOptionsPage::OnActive()
{
	/// Hong 01/15/06 REMOVE_FROM_BINARY_GUI
	// no need to support extraction of variables from file name for binary files 
	//BOOL bShow = (FILTER_TYPE_ASCII != fuGetType(IW_FILTER));
	BOOL bShow = false;
	/// REMOVE_FROM_BINARY_GUI
	m_grpExtractVar.Visible = bShow;
	m_chkExtractByDelim.Visible = bShow;
	m_chkExtractByPos.Visible = bShow;

	
	FilterToDialog();
	return TRUE;
}

BOOL IWFileNameOptionsPage::OnKillActive()
{
	/// Hong 02/27/07 QA80-9410 MORE_RENAME_WORKSHEET_WITH_VARIABLE
	if( m_chkRenWksWithVar.Check )
	{
		string strVarName = m_ebWksVarName.Text;
		strVarName.MakeValidCName('_');
		fuSetRenameWksVarName(IW_FILTER, strVarName);
	}
	/// end MORE_RENAME_WORKSHEET_WITH_VARIABLE
	///---Sim 03-06-2007 MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF
	if( m_chkRenWkbkWithVar.Check )
	{
		string strVarName = m_ebWkbkVarName.Text;
		strVarName.MakeValidCName('_');
		fuSetRenameWkbkVarName(IW_FILTER, strVarName);
	}
	///---END MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF
	m_pSheet->UpdateImpStructFromTree();//Hong 9/05/06 UPDATE_ASCIMP_AND_BINIMP
	return TRUE;
}

//--------------------------------------------------------------------------
// Functions for handling dialog control events
//--------------------------------------------------------------------------

///---Sim 02-01-2007 ADD_AUTO_RENAME
BOOL IWFileNameOptionsPage::OnClickAutoRename(Control ctrl)
{
	int nVal = (m_chkAutoRename.Check ? 1 : 0);
	fuSetAutoRename(IW_FILTER, nVal);
	
	EnableCtrl(); ///---Sim 02-01-2007 ADD_AUTO_RENAME
	
	return TRUE;
}	
///---END ADD_AUTO_RENAME

BOOL IWFileNameOptionsPage::OnClickRenWksToFName(Control ctrl)
{
	/// Hong 8/31/06 GET_FILTER_BY_ID
	//IW_FILTER.Common.RenameWks.nVal = (m_chkRenWksToFName.Check ? 1 : 0);
	int nVal = (m_chkRenWksToFName.Check ? 1 : 0);
	fuSetRenameWks(IW_FILTER, nVal);
	/// end GET_FILTER_BY_ID
	/// Hong 02/26/07 ADD_WORKSHEET_TO_FIRST_VARIABLE
	if( m_chkRenWksToFName.Check )
	{
		/// Hong 02/27/07 QA80-9410 MORE_RENAME_WORKSHEET_WITH_VARIABLE
		//m_chkRenWkbkToFirstVar.Check = 0;
		//fuSetRenameWksWithVar(IW_FILTER, 0);
		m_chkRenWksWithVar.Check = 0;
		//m_ebWksVarName.Enable = 0; ///---Sim 03-13-2007 CENTRALIZE_FILE_NAME_OPTIONS_ENABLE remove
		fuSetRenameWksWithVar(IW_FILTER, 0);
		/// end MORE_RENAME_WORKSHEET_WITH_VARIABLE
	}
	/// end ADD_WORKSHEET_TO_FIRST_VARIABLE
	EnableCtrl(); ///---Sim 03-13-2007 CENTRALIZE_FILE_NAME_OPTIONS_ENABLE
	return TRUE;
}
/// Hong 02/27/07 QA80-9410 MORE_RENAME_WORKSHEET_WITH_VARIABLE
/*
/// Hong 02/26/07 ADD_WORKSHEET_TO_FIRST_VARIABLE
BOOL IWFileNameOptionsPage::OnClickRenWksWithFirstVar(Control ctrl)
{
	int nVal = (m_chkRenWkbkToFirstVar.Check ? 1 : 0);
	fuSetRenameWksWithVar(IW_FILTER, nVal);

	if(m_chkRenWkbkToFirstVar.Check)
	{
		m_chkRenWksToFName.Check = 0;
		fuSetRenameWks(IW_FILTER, 0);	
	}

	return TRUE;
}
/// end ADD_WORKSHEET_TO_FIRST_VARIABLE
*/
BOOL IWFileNameOptionsPage::OnClickRenWksWithVar(Control ctrl)
{
	int nVal = (m_chkRenWksWithVar.Check ? 1 : 0);
	fuSetRenameWksWithVar(IW_FILTER, nVal);
	//m_ebWksVarName.Enable = nVal; ///---Sim 03-13-2007 CENTRALIZE_FILE_NAME_OPTIONS_ENABLE remove

	if(m_chkRenWksWithVar.Check)
	{
		m_chkRenWksToFName.Check = 0;
		fuSetRenameWks(IW_FILTER, 0);	
	}

	EnableCtrl(); ///---Sim 03-13-2007 CENTRALIZE_FILE_NAME_OPTIONS_ENABLE
	return TRUE;
}
/// end MORE_RENAME_WORKSHEET_WITH_VARIABLE

BOOL IWFileNameOptionsPage::OnClickRenWkbkToFName(Control ctrl)
{
	EnableFlag(AI_FLAG_FNAME_TO_WKBK_NAME, m_chkRenWkbkToFName.Check);
	///---Sim 03-06-2007 MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF
	if( m_chkRenWkbkToFName.Check )
	{
		m_chkRenWkbkWithVar.Check = 0;
		//m_ebWkbkVarName.Enable = 0; ///---Sim 03-13-2007 CENTRALIZE_FILE_NAME_OPTIONS_ENABLE remove
		fuSetRenameWkbkWithVar(IW_FILTER, 0);
	}
	///---END MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF
	EnableCtrl(); ///---Sim 03-13-2007 CENTRALIZE_FILE_NAME_OPTIONS_ENABLE
	return TRUE;
}
///---Sim 03-06-2007 MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF
BOOL IWFileNameOptionsPage::OnClickRenWkbkWithVar(Control ctrl)
{
	int nVal = (m_chkRenWkbkWithVar.Check ? 1 : 0);
	fuSetRenameWkbkWithVar(IW_FILTER, nVal);
	//m_ebWkbkVarName.Enable = nVal; ///---Sim 03-13-2007 CENTRALIZE_FILE_NAME_OPTIONS_ENABLE remove

	if(m_chkRenWkbkWithVar.Check)
	{
		m_chkRenWkbkToFName.Check = 0;
		fuSetRenameWorkbook(IW_FILTER, 0);	
	}

	EnableCtrl(); ///---Sim 03-13-2007 CENTRALIZE_FILE_NAME_OPTIONS_ENABLE
	return TRUE;
}
///---END MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF

///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
BOOL IWFileNameOptionsPage::OnClickRenWkbkLnOnly(Control ctrl)
{
	EnableFlag(AI_FLAG_FNAME_TO_WKBK_LONG_NAME_ONLY, m_chkRenWkbkLnOnly.Check);
	return TRUE;
}
///---END QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
///---Sim 02-25-2007 ADD_OPTION_FILE_PATH_FOR_WORKBOOK
BOOL IWFileNameOptionsPage::OnClickRenWkbkFPath(Control ctrl)
{
	EnableFlag(AI_FLAG_REMOVE_FNAME_PATH_FOR_WKBK_NAME, (0 == m_chkRenWkbkFPath.Check));
	return TRUE;
}
///---END ADD_OPTION_FILE_PATH_FOR_WORKBOOK

BOOL IWFileNameOptionsPage::OnClickAppendFNameToWkbkComm(Control ctrl)
{
	// Before we had workbooks we appended the file name to the worksheet label
	// We keep this tree node so the filter can be used with older versions of Origin.
	/// Hong 8/31/06 GET_FILTER_BY_ID
	//IW_FILTER.Common.FileNameToWksLabel.nVal = (m_chkAppendFNameToWkbkComm.Check ? 1 : 0);
	//int nVal = (m_chkAppendFNameToWkbkComm.Check ? 1 : 0);
	//fuSetFileNameToWksLabel(IW_FILTER, nVal);
	// New code uses a flag.
	EnableFlag(AI_FLAG_FNAME_TO_WKBK_COMMENTS, m_chkAppendFNameToWkbkComm.Check);
	EnableCtrl(); ///---Sim 03-13-2007 CENTRALIZE_FILE_NAME_OPTIONS_ENABLE
	return TRUE;
}

BOOL IWFileNameOptionsPage::OnClickAppendFNameToColComm(Control ctrl)
{
	EnableFlag(AI_FLAG_FNAME_TO_COL_COMMENTS, m_chkAppendFNameToColComm.Check);
	EnableCtrl(); ///---Sim 03-13-2007 CENTRALIZE_FILE_NAME_OPTIONS_ENABLE
	return TRUE;
}

BOOL IWFileNameOptionsPage::OnClickAppendFPath(Control ctrl)
{
	EnableFlag(AI_FLAG_REMOVE_FNAME_PATH, (0 == m_chkAppendFPath.Check));
	return TRUE;
}

//--------------------------------------------------------------------------
// Utility functions specific for this page
//--------------------------------------------------------------------------

void IWFileNameOptionsPage::EnableFlag(DWORD dwFlag, BOOL bEnable)
{
	///---Sim 08-31-2006 GET_FILTER_BY_ID
	/*
	DWORD dwFlags = tree_node_get_int(IW_FILTER.Common.Flags, 0);
	if( bEnable )
		dwFlags |= dwFlag;
	else
		dwFlags &= ~dwFlag;
	IW_FILTER.Common.Flags.nVal = dwFlags;
	*/
	fuSetFlag(IW_FILTER, dwFlag, bEnable);
	///---END GET_FILTER_BY_ID
}

void IWFileNameOptionsPage::FilterToDialog()
{
	m_chkAutoRename.Check = fuGetInt(IW_FILTER, IDE_DISP_IMP_AUTO_RENAME, 0); ///---Sim 02-01-2007 ADD_AUTO_RENAME
	/// Hong 8/31/06 GET_FILTER_BY_ID
	//m_chkRenWksToFName.Check = tree_node_get_int(IW_FILTER.Common.RenameWks, 0);
	m_chkRenWksToFName.Check = fuGetInt(IW_FILTER, IDE_IMP_RENAMEWKS, 0);
	//m_chkAppendFNameToWkbkComm.Check = tree_node_get_int(IW_FILTER.Common.FileNameToWksLabel, 1);
	//m_chkAppendFNameToWkbkComm.Check = fuGetInt(IW_FILTER, IDE_DISP_IMP_FNAMETOWKSLAB, 1);
	//DWORD dwFlags = tree_node_get_int(IW_FILTER.Common.Flags, 0);
	//m_chkRenWkbkToFName.Check = dwFlags & AI_FLAG_FNAME_TO_WKBK_NAME;
	m_chkRenWkbkToFName.Check = fuGetFlag(IW_FILTER, AI_FLAG_FNAME_TO_WKBK_NAME, 0);
	m_chkRenWkbkLnOnly.Check = fuGetFlag(IW_FILTER, AI_FLAG_FNAME_TO_WKBK_LONG_NAME_ONLY, 0); ///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
	m_chkRenWkbkFPath.Check = ( 0 == fuGetFlag(IW_FILTER, AI_FLAG_REMOVE_FNAME_PATH_FOR_WKBK_NAME, 0) ); ///---Sim 02-25-2007 ADD_OPTION_FILE_PATH_FOR_WORKBOOK
	//m_chkAppendFNameToWkbkComm.Check = dwFlags & AI_FLAG_FNAME_TO_WKBK_COMMENTS;
	m_chkAppendFNameToWkbkComm.Check = fuGetFlag(IW_FILTER, AI_FLAG_FNAME_TO_WKBK_COMMENTS, 0);
	//m_chkAppendFNameToColComm.Check = dwFlags & AI_FLAG_FNAME_TO_COL_COMMENTS;
	m_chkAppendFNameToColComm.Check = fuGetFlag(IW_FILTER, AI_FLAG_FNAME_TO_COL_COMMENTS, 0);
	//m_chkAppendFPath.Check = 0 == (dwFlags & AI_FLAG_REMOVE_FNAME_PATH);
	m_chkAppendFPath.Check = ( 0 == fuGetFlag(IW_FILTER, AI_FLAG_REMOVE_FNAME_PATH, 0) );
	/// end GET_FILTER_BY_ID
	/// Hong 02/27/07 QA80-9410 MORE_RENAME_WORKSHEET_WITH_VARIABLE
	//m_chkRenWkbkToFirstVar.Check = fuIsRenameWksWithVar(IW_FILTER); // Hong 02/26/07 ADD_WORKSHEET_TO_FIRST_VARIABLE
	string strVarName;
	m_chkRenWksWithVar.Check = fuIsRenameWksWithVar(IW_FILTER);
	//m_ebWksVarName.Enable = m_chkRenWksWithVar.Check; ///---Sim 03-13-2007 CENTRALIZE_FILE_NAME_OPTIONS_ENABLE remove
	fuGetRenameWksVarName(IW_FILTER, strVarName);		
	m_ebWksVarName.Text = strVarName;
	/// end MORE_RENAME_WORKSHEET_WITH_VARIABLE
	///---Sim 03-06-2007 MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF
	m_chkRenWkbkWithVar.Check = fuIsRenameWkbkWithVar(IW_FILTER);
	//m_ebWkbkVarName.Enable = m_chkRenWkbkWithVar.Check; ///---Sim 03-13-2007 CENTRALIZE_FILE_NAME_OPTIONS_ENABLE remove
	fuGetRenameWkbkVarName(IW_FILTER, strVarName);		
	m_ebWkbkVarName.Text = strVarName;
	///---END MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF
	
	EnableCtrl(); ///---Sim 02-01-2007 ADD_AUTO_RENAME
}
/// end EXTRACT_VARS_FROM_FILENAME

///---Sim 02-01-2007 ADD_AUTO_RENAME
void IWFileNameOptionsPage::EnableCtrl()
{
	///---Sim 03-13-2007 CENTRALIZE_FILE_NAME_OPTIONS_ENABLE
	/*
	bool bEnable = !( m_chkAutoRename.Check );
	
	m_chkRenWksToFName.Enable = bEnable;
	m_chkRenWkbkToFName.Enable = bEnable;
	//m_chkRenWkbkFPath.Enable = bEnable;
	/// Hong 02/27/07 QA80-9410 MORE_RENAME_WORKSHEET_WITH_VARIABLE
	//m_chkRenWkbkToFirstVar.Enable = bEnable; // Hong 02/26/07 ADD_WORKSHEET_TO_FIRST_VARIABLE
	m_chkRenWksWithVar.Enable = bEnable;
	m_ebWksVarName.Enable = bEnable && m_chkRenWksWithVar.Check;
	/// end MORE_RENAME_WORKSHEET_WITH_VARIABLE
	///---Sim 03-06-2007 MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF
	m_chkRenWkbkWithVar.Enable = bEnable;
	m_ebWkbkVarName.Enable = bEnable && m_chkRenWkbkWithVar.Check;
	///---END MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF
	//m_chkAppendFNameToWkbkComm.Enable = bEnable;
	//m_chkAppendFNameToColComm.Enable = bEnable;
	//m_chkAppendFPath.Enable = bEnable;
	*/
	
	bool bRenameWks, bRenameWksPartial, bRenameWkbk, bRenameWkbkPartial, bRenameWkbkIncludePath, bAppendIncludePath;
	///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
	bool bRenameWkbkLnOnly;
	//getEnableValueForFileNameOptions(m_chkAutoRename.Check,
		//m_chkRenWksToFName.Check, m_chkRenWkbkToFName.Check, m_chkAppendFNameToWkbkComm.Check, m_chkAppendFNameToColComm.Check,
		//bRenameWks, bRenameWksPartial, bRenameWkbk, bRenameWkbkPartial, bRenameWkbkIncludePath, bAppendIncludePath);
	getEnableValueForFileNameOptions(m_chkAutoRename.Check,
		m_chkRenWksToFName.Check, m_chkRenWkbkToFName.Check, m_chkAppendFNameToWkbkComm.Check, m_chkAppendFNameToColComm.Check,
		bRenameWks, bRenameWksPartial, bRenameWkbk, bRenameWkbkPartial, bRenameWkbkLnOnly, bRenameWkbkIncludePath, bAppendIncludePath);
	///---END QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME

	m_chkRenWksToFName.Enable 	= bRenameWks;
	m_chkRenWksWithVar.Enable 	= bRenameWks;
	m_ebWksVarName.Enable 		= bRenameWks && m_chkRenWksWithVar.Check;
	
	m_chkRenWkbkToFName.Enable 	= bRenameWkbk;
	m_chkRenWkbkWithVar.Enable 	= bRenameWkbk;
	m_ebWkbkVarName.Enable 		= bRenameWkbk && m_chkRenWkbkWithVar.Check;
	m_chkRenWkbkLnOnly.Enable	= bRenameWkbkLnOnly || m_chkRenWkbkWithVar.Check; ///---Sim 02-27-2008 QA80-11163 IMPORT_RENAME_BOTH_BOOK_LONG_AND_SHORT_NAME
	m_chkRenWkbkFPath.Enable	= bRenameWkbkIncludePath || m_chkRenWkbkWithVar.Check; // path both for filename and variable
	
	m_chkAppendFPath.Enable		= bAppendIncludePath;
	///---END CENTRALIZE_FILE_NAME_OPTIONS_ENABLE
}
///---END ADD_AUTO_RENAME
